'use strict';
CKEDITOR.plugins.add( 'ck-info', {
	requires: 'widget',
	icons: 'ck-info',
	init: function( editor ) {
		editor.addContentsCss( this.path + 'contents.css' );
		editor.widgets.add( 'ck-info', {
			allowedContent:
				'div(*);' +
				'svg(*){*}[*]; use(*){*}[*];'+
				'h2(*);',

			requiredContent: 'div(ck-info)',
			editables: {
				title: {
					selector: '.ck-info__title',
					allowedContent: ' '
				},
				content: {
					selector: '.ck-info__content'
				}
			},

			template:
				'<div class="ck-info">' +
					'<svg class="ck-info__icon icon">' +
						'<use class="test" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="/frontend/img/icons.svg#info"></use>' +
					'</svg>'+
					'<div class="flex--1">'+
						'<h2 class="ck-info__title">Virsraksts</h2>' +
						'<div class="ck-info__content"><p>Saturs</p></div>' +
					'</div>' +
				'</div>',

			button: 'Info box',
			upcast: function( element ) {
				return element.name == 'div' && element.hasClass( 'ck-info' );
			}
		} );
	}
} );