<?php

use yii\gii\generators\crud\Generator;
use yii\helpers\Inflector;
use yii\helpers\StringHelper;
use yii\web\View;

/* @var $this View */
/* @var $generator Generator */

$urlParams = $generator->generateUrlParams();
$nameAttribute = $generator->getNameAttribute();

echo "<?php\n";
?>

use yii\helpers\Html;
use yii\helpers\Url;
use <?= $generator->indexWidgetType === 'grid'
        ? "yii\\grid\\GridView"
        : "yii\\widgets\\ListView" ?>;
<?= $generator->enablePjax
        ? 'use yii\widgets\Pjax;'
        : '' ?>

/* @var $this yii\web\View */
<?= !empty($generator->searchModelClass)
        ? "/* @var \$searchModel " . ltrim($generator->searchModelClass, '\\') . " */\n"
        : '' ?>
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = <?= $generator->generateString(Inflector::pluralize(Inflector::camel2words(StringHelper::basename($generator->modelClass)))) ?>;
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="<?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>-index">
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= "<?= " ?>Html::encode($this->title) ?></h5>
                    <div class="ibox-tools">
             <?= "<?= " ?> Html::a(<?= $generator->generateString('Add new ' . Inflector::camel2id(StringHelper::basename($generator->modelClass))) ?>, ['create'], ['class' => 'btn btn-primary btn-xs']) <?= "?>" ?>
                    </div>
                </div>
                    <?php if (!empty($generator->searchModelClass)): ?>
                        <?= "    <?php " . ($generator->indexWidgetType === 'grid'
                                ? "// "
                                : "") ?>echo $this->render('_search', ['model' => $searchModel]); ?>
                    <?php endif; ?>
                <div class="ibox-content">
                    <?= $generator->enablePjax
                            ? '<?php Pjax::begin(); ?>'
                            : '' ?>
                    <?php if ($generator->indexWidgetType === 'grid'): ?>
                        <?= "<?= " ?>GridView::widget([
                        'dataProvider' => $dataProvider,
                        <?= !empty($generator->searchModelClass)
                                ? "'filterModel' => \$searchModel,\n        'columns' => [\n"
                                : "'columns' => [\n"; ?>
                        ['class' => 'yii\grid\SerialColumn'],

                        <?php
                        $count = 0;
                        if (($tableSchema = $generator->getTableSchema()) === false) {
                            foreach ($generator->getColumnNames() as $name) {
                                if (++$count < 6) {
                                    echo "            '" . $name . "',\n";
                                } else {
                                    echo "            // '" . $name . "',\n";
                                }
                            }
                        } else {
                            foreach ($tableSchema->columns as $column) {
                                $format = $generator->generateColumnFormat($column);
                                if (++$count < 6) {
                                    echo "            '" . $column->name . ($format === 'text'
                                            ? ""
                                            : ":" . $format) . "',\n";
                                } else {
                                    echo "            // '" . $column->name . ($format === 'text'
                                            ? ""
                                            : ":" . $format) . "',\n";
                                }
                            }
                        }
                        ?>

                        [
                                'class' => 'yii\grid\ActionColumn',
                                'header' => Yii::t('general', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                '<?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>/update',
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                '<?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>/delete',
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => <?= $generator->generateString('Delete ' . Inflector::camel2id(StringHelper::basename($generator->modelClass))) ?>,
                                            'data-text' => <?= $generator->generateString('Are you sure, you want to delete ' . Inflector::camel2id(StringHelper::basename($generator->modelClass))) ?> .' '.$model->title.'?',
                                            'data-cancel' => Yii::t('general', 'Cancel'),
                                            'data-ok' => Yii::t('general', 'Ok'),
                                        ]);
                                    },
                                ],
                            ],
                        ], 'tableOptions' => ['class' => 'table table-striped'],
                        ]); ?>
<?php else: ?>
    <?= "<?= " ?>ListView::widget([
                        'dataProvider' => $dataProvider,
                        'itemOptions' => ['class' => 'item'],
                        'itemView' => function ($model, $key, $index, $widget) {
                        return Html::a(Html::encode($model-><?= $nameAttribute ?>), ['view', <?= $urlParams ?>]);
                        },
                        ]) ?>
<?php endif; ?>
<?= $generator->enablePjax
        ? '<?php Pjax::end(); ?>'
        : '' ?>
                </div>
            </div>
        </div>
    </div>
</div>
