CKEDITOR.plugins.add( 'ck-gallery', {
	requires: 'widget',
	icons: 'ck-gallery',
	init: function( editor ) {
		CKEDITOR.dialog.add( 'ck-gallery', this.path + 'dialogs/ck-gallery.js' );
		editor.addContentsCss( this.path + 'contents.css?v7' );

        var galleryTemplate = "<div class=\"gallery-preview gallery-preview--editor js-gallery-preview bottom-margin--30\" data-index=\"\">\n\t\t\t\t\t\t<figure class=\"image  image--aspect\" style=\"padding: 0 0 66.666666666667% 0\">\n\t\t\t\t\t\t\t<img alt=\"\" data-original=\"\" />\n\t\t\t\t\t\t</figure>\n\t\t\t\t\t\t<div class=\"gallery-preview__content\">\n\t\t\t\t\t\t\t<h3 class=\"gallery-preview__heading\"></h3>\n\t\t\t\t\t\t\t<span class=\"gallery-preview__author\"></span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>";

		editor.widgets.add( 'ck-gallery', {
			allowedContent: 'div(*)[*]; figure(*)[*]; img(*)[*]; h3(*)[*]; span(*)[*]',

			//requiredContent: 'div(gallery-preview); img;',
			requiredContent: 'div(*)[*]; figure(*)[*]; img(*)[*]; h3(*)[*]; span(*)[*]',

			// Define the template of a new Simple Box widget.
			// The template will be used when creating new instances of the Simple Box widget.
			template: galleryTemplate,

			button: 'Insert gallery',

			dialog: 'ck-gallery',

			upcast: function( element ) {
				return element.name == 'div' && element.hasClass( 'ck-gallery' );
			},

			init: function() {
				var galleryID = this.element.getAttribute('data-index');
				var galleryName = this.element.getAttribute('data-name');
				var galleryImage = this.element.getAttribute('data-image');
				var galleryAuthor = this.element.getAttribute('data-author');

				if(galleryID){
					this.setData('galleryID', galleryID);
				}
				if(galleryName){
					this.setData('galleryName', galleryName);
				}
				if(galleryImage){
					this.setData('galleryName', galleryImage);
				}
				if(galleryAuthor){
					this.setData('galleryName', galleryAuthor);
				}
			},

			data: function() {

                this.element.setAttribute('data-index', this.data.galleryID);
                this.element.setAttribute('data-name', this.data.galleryName);
                this.element.setAttribute('data-image', this.data.galleryImage);
                this.element.setAttribute('data-author', this.data.galleryAuthor);
				// this.element.setText(this.data.galleryName);
                this.element.findOne('img').setAttribute('src', this.data.galleryImage);
                this.element.findOne('.gallery-preview__heading').setText(this.data.galleryName);
                this.element.findOne('.gallery-preview__author').setText(this.data.galleryAuthor);


			}
		} );
	}
} );