White Digital Yii2 Module Composer Package Project Template
===========================================================

A project template for a Yii2 module package.

* * *

# Configuration
## Configure gii module, to use custom INSPINIA generator
        $config['modules']['gii'] = [
            'class' => 'yii\gii\Module',
            'allowedIPs' => ['*'], // access gii module from all ip adresses (change if necessary)
            'generators' => [ //here
                'crud' => [ // generator name
                    'class' => 'wdigital\cms\inspinia\generators\crud\Generator', // generator class
                    'templates' => [ //setting for out templates
                        'inspinia' => '@vendor/wdigital/cms-inspinia/src/generators/crud/inspinia', // template name => path to template
                    ]
                ]
            ],
        ];
## Configure view and formatter component for app, to use inspinia view templates and proper date format
        'view' => [
            'theme' => [
                'basePath' => '@vendor/wdigital/cms-inspinia',
                'baseUrl' => '@vendor/wdigital/cms-inspinia',
                'pathMap' => [
                    '@app/views' => '@vendor/wdigital/cms-inspinia/src/views',
                ],
            ],
        ],
        'formatter' => [
            'dateFormat' => 'php:d.m.Y',
            'nullDisplay' => '',
        ],
## For sidebar to work you have to add a menu variable in params as so
        'menu' => [
                        [
                            'label' => 'WD Admin Panel',
                            'url' => Url::to('/'),
                            'options' => [
                                    'class' => 'nav-header h3'
                            ],
                        ],
                        [
                            'label' => Yii::t('general', 'Dashboard'),
                            'url'  => Url::to('/'),
                            'icon'  => 'fa fa-th-large',
                            'options' =>
                                [
                                    'class' => 'active',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Site tree'),
                            'url'  => Url::to('/site-tree/default/index'),
                            'icon' => 'fa fa-sitemap',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Languages and translations'),
                            'url'  => Url::to('/language/default/index'),
                            'icon' => 'fa fa-language',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Users and User Groups'),
                            'url'  => Url::to('/user/admin/index'),
                            'icon' => 'fa fa-users',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                ],
                
If you wish to show/hide items in the sidebar menu based on RBAC permissions (wdigital/cms-rbac package) you must add a parameter"permission":
                        
                [
                    'label' => Yii::t('general', 'Users and User Groups'),
                    'url'  => Url::to('/user/admin/index'),
                    'icon' => 'fa fa-users',
                    'options' =>
                        [
                            'class' => '',
                        ]
                    'permission' => ['Users', 'User groups']
                ],
                
 Entries in permission array must correspond to permission names from RBAC module.
 
 If permission key is not set or is an empty array, menu item will be available for all users 
                          
## Site tree new content type link generation
Site Tree redactor links for new content types are generated using the content type names in links, 
for example if you create a new content type called *news* when you are going to click on the site tree
section itself you will be redirected to a link:

                /content-type/index?id=section-id
                
and therefore you will have to have a controller in your *app/views/controller*
folder named after the content-type or 
you will have to pathmap it.
## Sortable update for pagination.
If you want to add an order field for you pagination, you should add an 
action to your controller like this (don't forget a field order_by in your model!):

            public function actionChangeorder($id)
                {
                    $post = Yii::$app->request->post();
                    $model = /*YourModel*/::find()->where(['id'=> $id])->limit(1)->one();
                    if($model->order_by == $post['value']){
                        return 0;
                    }else {
                        $model->order_by = $post['value'];
                        $model->save();
                        $all_after_found = /*YourModel*/::find()->where(['>=','order_by', $post['value']])->orderBy('order_by asc')->all();
                        foreach($all_after_found as $one){
                            if($one->id != $model->id) {
                                $one->order_by = $post['value'] + 1;
                                $post['value'] += 1;
                                $one->save();
                            }
                        }
                        return 1;
                    }
                    return 0;
            
                }
And you should add a row like this:

            [
                'class' => 'yii\grid\ActionColumn',
                'header' => Yii::t('general', 'Order By'),
                'template' => '{reorder}',
                'buttons' => [
                    'reorder' => function ($url, $model, $key) {
                        return '<div class="btn-group">'.Html::textInput(
                                'order_by',
                                       $model->order_by,
                                       ['attr-url'=>'/'.Yii::$app->language.'/*yourmodel*/changeorder?id='.$model->id,
                                       'type'=> 'number','min'=>'0',
                                       'class'=>'form-control sortable-input',
                                       ])
                            .'<span><button type="button" class="btn btn-xs btn-primary js-reorder-this margin-top__-5 " >
                                            <i class="fa fa-check"></i></button></span></div>';
                    },
                ],
            ],

### AssetManager configuration
If your project depends on other package assets, to use them in conjunction with Inspinia assets, configure assetManager as so

        'assetManager' => [
                    'bundles' => [
                        'wdigital\cms\inspinia\assets\AppAsset' => [
                            'depends' => [
                            'wdigital\cms\inspinia\assets\InspiniaAsset',
                            'wdigital\cms\gallery\assets\GalleryAsset' // add other package assets
                            ],
                        ],
                    ],
                ],