<?php

use wdigital\cms\i18n\components\LanguageArray;
use yii\helpers\Url;
use yii\helpers\Html;
/**
 * Dummy array for language dropdown in admin header.
 *
 */

if (Yii::$app->hasModule('language')) {
    $languages = Yii::$app->params['languages'];
}
?>
<nav class="navbar navbar-static-top  " role="navigation" style="margin-bottom: 0">

    <?php if(!\Yii::$app->user->isGuest): ?>
    <div class="navbar-header">
        <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
    </div>
    <?php endif?>

    <ul class="nav navbar-top-links navbar-right">
        <?php if (Yii::$app->hasModule('language')) : ?>
        <li class="dropdown">
            <a aria-expanded="false" role="button" href="#" class="dropdown-toggle" data-toggle="dropdown">
                <?= LanguageArray::getLanguage(Yii::$app->language) ?>
                <span class="caret"></span></a>
            <ul role="menu" class="dropdown-menu">
                <?php foreach($languages as $language): ?>
                    <li><a href="<?= Url::to(['/', 'language' => Html::encode($language['code'])]) ?>"><?= Html::encode($language['name']) ?></a></li>
                <?php endforeach; ?>
            </ul>
        </li>
        <?php endif; ?>
        <li>
            <?php if(!\Yii::$app->user->isGuest): ?>
            <span class="m-r-sm text-muted welcome-message"><?=Yii::t('general', 'Hello, ')?><?=\Yii::$app->user->identity->username?></span>
            <?php endif?>
        </li>
        <?php if(\Yii::$app->user->isGuest):?>
        <li>
            <a href="<?=Url::to(['site/login'])?>">
                <i class="fa fa-sign-in"></i>
            </a>
        </li>
        <?php else:?>
        <li>
            <a href="<?=Url::to(['site/logout'])?>" data-method="post">
                <i class="fa fa-sign-out"></i>
            </a>
        </li>

        <?php endif?>
    </ul>

</nav>