var map;
function initMap() {
    var latValue = parseFloat(document.getElementById('latitude').value);
    var lngValue = parseFloat(document.getElementById('longitude').value);
    map = new google.maps.Map(document.getElementById('map'), {
        center: {lat: latValue, lng: lngValue},
        zoom: 7,
        draggable: true
    });
    var marker = new google.maps.Marker({
        position: { lat: latValue, lng: lngValue},
        map: map,
        draggable: true
    });
    google.maps.event.addListener(marker, 'dragend', function (evt) {
        document.getElementById('latitude').value = evt.latLng.lat().toFixed(7);
        document.getElementById('longitude').value = evt.latLng.lng().toFixed(7);
    });

}