<?php

use wdigital\cms\inspinia\widgets\SiteTree;
use yii\base\DynamicModel;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$model = new DynamicModel(['id' => 3, 'name' => 'Testa sadaļa', 'slug' => 'testa-sadala', 'type' => 'HTML', 'parent_id' => '2']);
$section2 = new DynamicModel (['id' => 3, 'name' => 'Testa sadaļa', 'slug' => 'testa-sadala2', 'type' => 'HTML', 'parent_id' => '2', 'fullSlug' => '/testa-sadala/testa-sadala2']);
$children = [$section2];
$section1 = new DynamicModel(['id' => 2, 'name' => 'Testa sadaļa', 'slug' => 'testa-sadala', 'type' => 'HTML', 'parent_id' => '','children'=>$children , 'fullSlug'=>'/testa-sadala']);

$sections = [$section1];
$this->title = Yii::t('section', 'Edit section: ') . $model->name;
$this->params['breadcrumbs'][] = $this->title;
$parents = ['0' => 'Pirmā sadaļa', '1' => 'Otrā sadaļa', '2' => 'Īstā sadaļa'];
?>
<div>
    <div class="row">
        <div class="col-lg-6 ">
            <div class="ibox-content animated fadeInUp">

                <div id="jstree1">
                    <?php
                    $sitetree = new SiteTree();
                    echo $sitetree->renderTree($sections,1,true,'');
                    ?>

                </div>

            </div>
        </div>
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <small class="pull-right"><?= Yii::t('section', 'By submitting this form, you can edit this section') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['section/edit', 'lang' => Yii::$app->language, 'id' => $model->id],
                            ])
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($parents) ?>
                    <?=
                    $form->field($model, 'type')->dropDownList([
                        'calendar' => 'Kalendārs',
                        'contacts' => 'Kontakti',
                        "html" => "HTML",
                        "news" => "Ziņu sadaļa",
                        "redirect" => "Pāradresēšanas/pagaidu sadaļa",
                        "gallery" => "Galeriju sadaļa",
                        "site-map" => "Lapas kartes sadaļa"
                    ])
                    ?>
                    <?= $form->field($model, 'name')->textInput(["data-slug-field" => "edit-name"]) ?>
                    <?= $form->field($model, 'slug')->textInput(["data-slug-target" => "edit-name"]) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('general', 'Edit'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
