<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$model = new yii\base\DynamicModel(['id' => 1, 'name' => 'Administratori',
    'access' => [
        'admin' => ['dashboard', 'site-tree'],
        'site-tree-options' => ['create', 'edit']
    ]]);
$this->title = Yii::t('user-group', 'Edit user group');
$this->params['breadcrumbs'][] = $this->title;
$cms_sections = ['dashboard' => 'Dashboard', 'site-tree' => 'Site tree', 'languages' => 'Languages', 'users-usergroups' => 'Users and UserGroups'];
$site_tree_actions = ['create' => Yii::t('general', 'Create'), 'edit' => Yii::t('general', 'Edit'), 'order' => Yii::t('general', 'Order'), 'delete' => Yii::t('general', 'Delete')];
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <small class="pull-right"><?= Yii::t('user-group', 'By submitting this form, you can create new user group') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'create-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['user-group/create', 'lang' => Yii::$app->language],
                            ])
                    ?>
                    <?= $form->field($model, 'name')->textInput() ?>
                    <?= $form->field($model, 'access[admin]')->checkboxList($cms_sections, ['separator' => '<br>']) ?>
                    <?= $form->field($model, 'access[site-tree-options]')->checkboxList($site_tree_actions, ['separator' => '<br>']) ?>
                    <p>Site tree widgets ar sadaļām</p>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('general', 'Edit'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
