<?php
namespace wdigital\cms\inspinia\widgets;

use Yii;
use yii\base\Widget;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\helpers\Html;

/**
 * Class Menu
 * Theme menu widget.
 */
class SiteTree extends Widget
{
    /**
     * @inheritdoc
     */
    public function renderTree($children,$active_section_id, $expanded, $tree, $seperator = '') {
        $tree .= '<ul>';
        foreach($children as $child){
            $tree .= '<li>'.$child->name;
            if(!empty($child->children)){
                $tree .= self::renderTree($child->children, '',$child->id,$active_section_id,$expanded,$tree,$child);
            }
            $tree .='<div class="controls pull-right">';
            $tree .='<a class="redirect inline-block ';
                    if($child->id == $active_section_id ? $tree .='active' : '');
            $tree .= 'js-tooltip-button';
            $tree .= 'title="Sadaļas uzstādījumi" data-placement="top"';
            $tree .= 'href="'.Url::to(['site-tree/edit', 'lang' => Yii::$app->language, 'id'=>$child->id]).'">';
            $tree .= '<i class="fa fa-wrench fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '<a class="js-clipboard" data-clipboard-action="copy" data-clipboard-text="'. Html::encode($child->fullSlug). '">';
            $tree .='<i class="fa fa-link fa-fw"></i>';
            $tree .= '</a>';
            $tree .='<a href="/site-tree/'.$child->id.'"></a>';
            $tree .= '<a href="#" class="dragHandle ui-sortable-handle js-tooltip-button" title="Mainīt secību" data-placement="top">';
            $tree .= '<i class="fa fa-arrows fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '<a href="'.Url::to(['site-tree/delete', 'lang' => Yii::$app->language, 'id'=>$child->id]).'"';
            $tree .= 'class="js-delete-button js-tooltip-button"';
            $tree .= 'data-title="Dzēst sadaļu"';
            $tree .= 'data-placement="top"';
            $tree .= 'data-text="Vai jūs tiešām vēlaties dzēst sadaļu '.Html::encode($child->name).' un tās apakšsadaļas?">';
            $tree .= '<i class="fa fa-trash fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '</div>';
            $tree .='</li>';
        }
        $tree .= '</ul>';
        return $tree;
    }

    public function renderTreePermissions($children,$active_section_id, $expanded, $tree, $seperator = '') {
        $tree .= '<ul>';
        foreach($children as $child){
            $tree .= '<li>';
            if($seperator != ''){
                $tree.= $seperator;
            }
            $tree.= $child->name;
            if(!empty($child->children)){
                $tree .= self::renderTree($child->children, '',$child->id,$active_section_id,$expanded,$tree,$child);
            }
            $tree .='</li>';
        }
        $tree .= '</ul>';
        return $tree;
    }
}
