<?php


namespace wdigital\cms\i18new\models;

use wdigital\cms\i18new\components\ActiveRecordHelper;
use wdigital\cms\i18new\models\Language;
use Yii;
use yii\db\ActiveRecord;

class StaticTranslationMessage extends ActiveRecord
{
    /**
     * @return string
     */
    public static function tableName(): string
    {
        return '{{%message}}';
    }

    /**
     * @return array
     */
    public function attributeLabels(): array
    {
        return [
            'translation' => Yii::t('language', 'Translation'),
        ];
    }

    /**
     * @param $data
     */
    public function updateMessages($data): void
    {
        unset($data["_csrf"]);
        foreach ($data as $language => $translations) {
            $model = new Language();
            $language_codes = ActiveRecordHelper::getColumnValues($model, 'code');
            if (in_array($language, $language_codes)) {
                foreach ($translations as $id => $translation) {
                    if ($translation == '') {
                        $translation = null;
                    }
                    $query = Yii::$app->db
                            ->createCommand()
                            ->update(self::tableName(), ['translation' => $translation], ['id' => $id, 'language' => $language])
                            ->execute();
                }
            } else {
                continue;
            }
        }
    }

    /**
     * @param string $code
     */
    public function deleteStaticTranslationsByLanguage(string $code): void
    {
        Yii::$app->db->createCommand()->delete(self::tablename(), ['language' => $code])->execute();
    }
}
