<?php
namespace wdigital\cms\i18new\models;

use Yii;
use yii\db\ActiveRecord;
use wdigital\cms\i18new\models\StaticTranslationMessage;

class StaticTranslation extends ActiveRecord {

    /**
     * @return string
     */
    public static function tableName(): string
    {
        return '{{%source_message}}';
    }

    /**
     * @return array
     */
    public function attributeLabels(): array
    {
        return [
            'category' => Yii::t('language', 'Category'),
            'message' => Yii::t('language', 'Message'),
        ];
    }

    /**
     * @return mixed
     */
    public function getAlltranslations()
    {
    	return $this->hasMany(StaticTranslationMessage::className(), ['id' => 'id']);
	}

    /**
     * @param string $code
     */
    public function generateStaticTranslationMessages(string $code): void
    {
        $translations = StaticTranslation::find()->all();
        $insertData = [];
        foreach($translations as $translation){
            $insertData[] = ['id' => $translation->id, 'language' => $code];
        }
        Yii::$app->db->createCommand()->batchInsert(StaticTranslationMessage::tablename(), ['id', 'language'], $insertData)->execute();
    }
}
