<?php

namespace wdigital\cms\i18new\models;

use Yii;
use yii\base\InvalidArgumentException;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;

class Language extends ActiveRecord {

    const SCENARIO_CREATE = 1;

    /**
     * @return array
     */
    public function rules(): array
    {
        return [
            [['code', 'name'], 'required'],
            ['code', 'string'],
            ['code', 'filter', 'filter' => 'strtolower'],
            ['code', 'unique'],
            ['active', 'safe'],
            ['code', 'string', 'max' => 6],
            ['order_by', 'filter', 'filter' => function () {
                return static::find()->max('order_by') + 1;
            }, 'on' => self::SCENARIO_CREATE],
        ];
    }

    /**
     * @return array
     */
    public function attributeLabels(): array
    {
        return [
            'code' => Yii::t('language', 'Language code'),
            'name' => Yii::t('language', 'Language name'),
            'active' => Yii::t('language', 'Is active'),
        ];
    }

    /**
     * @param int $id
     * @return string
     */
    public static function getCodeFromId($id): string
    {
        $languages = ArrayHelper::map(Yii::$app->params['languages'], 'id', function ($model) { return $model; });
        if (empty($languages[$id])) {
            throw new InvalidArgumentException("The language ID #{$id} is not a configured application language");
        }
        return $languages[$id]['code'];
    }
    /**
     * @param string $code
     * @return int
     */
    public static function getIdFromCode($code): int
    {
        $languages = ArrayHelper::map(Yii::$app->params['languages'], 'code', function ($model) { return $model; });
        if (empty($languages[$code])) {
            throw new InvalidArgumentException("The language code '{$code}' is not a configured application language");
        }
        return $languages[$code]['id'];
    }

    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);

        if ($insert) {
            if (!\Yii::$app->getModule('site-tree')->multipleSiteTree) {
                $sections = \Yii::$app->getModule('site-tree')->sectionClass::find()->all();
                foreach ($sections as $section) {
                    $section->getVariationModels();
                    $section->save();
                }
            }
        }
    }
}
