<?php

namespace wdigital\cms\i18new;


use Yii;
use yii\base\Exception;
use yii\base\Module as BaseModule;
use yii\helpers\ArrayHelper;


class Module extends BaseModule
{
    public $languageClass;
    /**
     * @throws Exception
     */
    public function init()
    {
        parent::init();
        try {
            if (Yii::$app instanceof yii\web\Application) {
                Yii::$app->params['languages'] = $this->languageClass::find()->asArray()->all();
                Yii::$app->urlManager->languages = ArrayHelper::getColumn(Yii::$app->params['languages'], 'code');
            }
        } catch (\Exception $e) {
            throw new Exception("Please make sure you are using codemix\yii2-localeurls package as your urlManager! \n 
            Check if language table exists in database, and has the correct structure");
        }
    }

}
