<?php

namespace wdigital\cms\i18new\controllers;

use wdigital\cms\i18new\components\LanguageArray;
use wdigital\cms\i18new\models\Language;
use wdigital\cms\i18new\models\StaticTranslation;
use wdigital\cms\i18new\models\StaticTranslationMessage;
use Yii;
use yii\data\ActiveDataProvider;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\helpers\Html;

class DefaultController extends Controller {

    /**
     * @return mixed
     */
    public function actionIndex()
    {
        $languages = Yii::$app->params['languages'];
        $langDataProvider = new ActiveDataProvider([
            'query' => Language::find(),
            'sort' => false,
        ]);
        if (Yii::$app->request->get('category')) {
            Yii::$app->session->set('language_category', Html::encode(Yii::$app->request->get('category')));
        }else{
            Yii::$app->session->set('language_category', null);
        }
        $dataProviders = [];
        foreach ($languages as $language) {
            $query = StaticTranslation::find()->joinWith(['alltranslations' => function ($q1) use ($language) {
                $q1->where(['message.language' => $language['code']]);
            }]);
            if (Yii::$app->session->get('language_category')) {
                $query->andWhere(['category' => Yii::$app->session->get('language_category')]);
            }
            $dataProviders[$language['code']] = new ActiveDataProvider([
                'query' => $query,
                'sort' => false,
                'pagination' => false,
            ]);
        }
        $categories = StaticTranslation::find()->select('category')->indexBy('category')->column();
        return $this->render('@vendor/wdigital/cms-i18new/src/views/default/index', [
            'languages' => $languages,
            'categories' => $categories,
            'dataProvider' => $langDataProvider,
            'dataProviders' => $dataProviders,
        ]);
    }

    /**
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Language();
        $model->scenario = Language::SCENARIO_CREATE;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $staticTranslation = new StaticTranslation();
            $staticTranslation->generateStaticTranslationMessages($model->code);
            return $this->redirect(Url::to(['index']));
        } else {
            if ($model->hasErrors()) {
                Yii::$app->response->statusCode = 422;
            }
            return $this->render('@vendor/wdigital/cms-i18new/src/views/default/create', [
               'model' => $model,
               'languages' => LanguageArray::getArray(),
            ]);
        }
    }

    /**
     * @param $id
     * @return mixed
     */
    public function actionEdit($id)
    {
        $model = Language::findOne($id);
        if ($model === null) {
            throw new NotFoundHttpException;
        }
        if (Yii::$app->request->isPost) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(Url::to(['index']));
            }
        }
        return $this->render('@vendor/wdigital/cms-i18new/src/views/default/edit', [
            'model' => $model,
            'languages' => LanguageArray::getArray(),
        ]);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $model = Language::findOne($id);
        if ($model === null) {
            throw new NotFoundHttpException;
        } else {
            $staticMessage = new StaticTranslationMessage();
            $staticMessage->deleteStaticTranslationsByLanguage($model->code);
            $model->delete();
            return $this->redirect(Url::to(['index']));
        }
    }

    /**
     * @return mixed
     */
    public function actionStatic()
    {
        if (Yii::$app->request->isPost){
            $post = Yii::$app->request->post();
            if ($post) {
                $staticMessage = new StaticTranslationMessage();
                $staticMessage->updateMessages($post);
            }
            return $this->redirect(Url::to(['index']));
        } else {
            throw new NotFoundHttpException;
        }

    }

}
