<?php

namespace wdigital\cms\i18new\components;

use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;

class ActiveRecordHelper
{

    /**
     * @param ActiveRecord $model
     * @param string $column
     * @return mixed
     */
    public static function getColumnValues(ActiveRecord $model, string $column)
    {
        $models = $model::find()->all();
        $data = ArrayHelper::toArray($models);
        $ids = ArrayHelper::getColumn($data, $column);
        return $ids;
    }

    /**
     * Helper for variationSaveFilter for saving variations or not
     * @param $model
     * @return bool
     */
    public static function filterVariationSave($model): bool
    {
        $final = false;
        foreach ($model::fillable() as $value) {
            $final = !empty($model->$value);
            if ($final) {
                break;
            }
        }
        return $final;
    }
}


