# White Digital CMS Internationalization Module using variation

The CMS Internationalization management module. Create languages and respective static translations used by built-in Yii i18n.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-i18new:^1.0.0

or add

    "wdigital/cms-i18new": "^1.0.0"

to the `require` section of your `composer.json` file.


### 2. Configure

> IMPORTANT! Ensure that your application does not have a `language` component configured beforehand.
Add module and name it in application configuration (preferrably in common config)

    'modules' => [
        // ...
        'language' => [
            'class' => wdigital\cms\i18new\Module::class
        ]
    ],

Add newly added `language` module to your bootstrapping modules, to make sure that migrations are injected
and routing package can use languages from database.

    'bootstrap' => ['language'],
Add Yii2 i18n static translation component in your application configuration to use your applications database as source for translated messages.
Also add `language*` translation to get support for EN and LV languages for backend UI

    'components' => [
        'i18n' => [
            'translations' => [
                'language*' => [
                    'class' => PhpMessageSource::class,
                    'basePath' => '@vendor/wdigital/cms-i18new/src/messages',
                    'sourceLanguage' => 'en-US',
                ],
                '*' => [
                    'class' => 'yii\i18n\DbMessageSource',
                    'forceTranslation'=>true,
                ],
            ],
        ],
    ]

### 3. Add migration namespace to console config and Migrate

    'controllerMap' => [
            'migrate' => [
                'class' => 'yii\console\controllers\MigrateController',
                'migrationNamespaces' => [
                    'wdigital\\cms\\i18new\\migrations',
                ]
            ],
    ],
    
    $ php yii migrate

### 4. When ready run console command to extract your applications static translations from code
You can do this as many times as you want, old translations will not be overwritten.

    $ php yii message vendor/wdigital/cms-i18new/src/messages.php

### 5. Configure application urlManager component, if you want to make your application multilingual
        'urlManager' => [
            'class' => codemix\localeurls\UrlManager::class,
            'languages' => [], //these will be overwritten by what you have in the database
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'enableDefaultLanguageUrlCode' => true,
            'enableLanguagePersistence' => false,
            'enableLanguageDetection' => false,
        ],

### 6. Use dynamic translation behavior
More info: https://github.com/yii2tech/ar-variation

Create migrations and respective models that contain DDL such as this:
        
        $this->createTable('product', [
            'id' => $this->primaryKey()->unsigned(),
            'title' => $this->string(),
            'slug' => $this->string(),
            'intro' => $this->text(),
            'image' => $this->string(),
            'content' => $this->text(),
        ]);

        $this->createTable('product_translation', [
            'product_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'title' => $this->string(),
            'slug' => $this->string(),
            'intro' => $this->text(),
            'content' => $this->text(),
        ]);

        $this->addPrimaryKey('pk_product_translation', 'product_translation', ['product_id', 'language_id']);
        $this->createIndex(
            'idx_product_translation_product', 'product_translation', 'product_id'
        );
        $this->addForeignKey(
            'fk_product_translation_product', 'product_translation', 'product_id', 'product', 'id', 'CASCADE'
        );
        $this->createIndex(
            'idx_product_translation_language', 'product_translation', 'language_id'
        );
        $this->addForeignKey(
            'fk_product_translation_language', 'product_translation', 'language_id', 'language', 'id', 'CASCADE'
        );
                
   Add behavior and relations to necessary model for example:
   
        public function behaviors() :array
        {
            return [
                'translations' => [
                    'class' => VariationBehavior::class,
                    'variationsRelation' => 'translations',
                    'defaultVariationRelation' => 'defaultTranslation',
                    'variationOptionReferenceAttribute' => 'language_id',
                    'optionModelClass' => Languages::class,
                    'defaultVariationOptionReference' => 1,
                    'variationSaveFilter' => [wdigital\cms\i18new\ActiveRecordHelper::class, 'filterVariationSave'],
                ],
            ];
        }
            
        /**
         * @return ActiveQuery
         */
        public function getTranslations(): ActiveQuery
        {
            return $this->hasMany(ProductTranslation::class, ['product_id' => 'id']);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getDefaultTranslation(): ActiveQuery
        {
            return $this->hasDefaultVariationRelation();
        }
Modify model load attribute functions:

        /**
        * @param array $data
        * @param null $formName
        * @return bool
        */
        public function load($data, $formName = null): bool
        {
            $translationModels = ArrayHelper::map(
                $this->getVariationModels(),
                'language_id',
                function ($translatedModel) {
                    return $translatedModel;
                }
            );
            return parent::load($data, $formName) && Model::loadMultiple($translationModels, $data)  && $this->setVariationModels($translationModels);
        }

[composer]: http://getcomposer.org/download/

