<?php

namespace wdigital\cms\i18new\migrations;

use yii\db\Migration;
/**
 * Handles the creation of table `language`.
 */
class m131114_140213_create_static_translation_tables extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%source_message}}', [
			'id' => $this->primaryKey()->unsigned(),
			'category' => $this->string(),
			'message' => $this->text(),
		], $tableOptions);
		$this->createTable('{{%message}}', [
			'id' => $this->integer()->notNull()->unsigned(),
			'language' => $this->string(6)->notNull(),
			'translation' => $this->text(),
		], $tableOptions);
		$this->addPrimaryKey('pk_message_id_language', '{{%message}}', ['id', 'language']);
		$this->addForeignKey('fk_message_source_message', '{{%message}}', 'id', '{{%source_message}}', 'id', 'CASCADE', 'RESTRICT');
		$this->createIndex('idx_source_message_category', '{{%source_message}}', 'category');
		$this->createIndex('idx_message_language', '{{%message}}', 'language');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropForeignKey('fk_message_source_message', '{{%message}}');
		$this->dropTable('{{%message}}');
		$this->dropTable('{{%source_message}}');

    }
}
