<?php

use yii\grid\ActionColumn;
use yii\grid\SerialColumn;
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;

/* @var $this View */
$this->title = Yii::t('language', 'Languages and translations');
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <!--Languages-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('language', 'Languages') ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('language', 'Add new language'),
                            Url::to(['create']),
                            ['class' => 'btn btn-primary btn-xs']) ?>
                    </div>
                </div>
                <div class="ibox-content">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider,
                        'columns' => [
                            ['class' => SerialColumn::class],
                            'code:text',
                            'name:text',
                            [
                                'class' => ActionColumn::class,
                                'header' => Yii::t('language', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'edit',
                                                'id' => $model->id
                                            ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'delete',
                                                'id' => $model->id
                                            ]), ['class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('language', 'Delete language'),
                                            'data-text' => Yii::t('language', 'Are you sure, you want to delete language') . ' ' . $model->name . '?',
                                            'data-cancel' => Yii::t('language', 'Cancel'),
                                            'data-ok' => Yii::t('language', 'Ok'),
                                        ]);
                                    },
                                ],
                            ]
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                        'summary' => ''
                    ]);
                    ?>
                </div>
            </div>
        </div>
    </div>
    <!--Translations-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('language', 'Translations') ?></h5>
                </div>
                <div class="ibox-content">
                    <div class="col-sm-offset-10 col-sm-2">
                        <form method="get">
                            <select class="form-control" name="category" onchange="submit()">
                                <option value=""><?= Yii::t('language', 'Category'); ?></option>
                                <?php foreach ($categories as $id => $category): ?>
                                    <option
                                        <?php if (isset(Yii::$app->session->isActive) && Yii::$app->session->get('language_category') === $id): ?> selected="selected" <?php endif ?>
                                            value="<?= $id ?>">
                                        <?= $category ?>
                                    </option>
                                <?php endforeach ?>
                            </select>
                        </form>
                    </div>
                    <?= Html::beginForm(['static', 'lang' => Yii::$app->language], 'post') ?>
                    <div class="tabs-container">
                        <ul class="nav nav-tabs">
                            <?php foreach ($languages as $language): ?>
                                <li<?php if (Yii::$app->language === $language['code']): ?> class="active"<?php endif; ?>>
                                    <a href="#tab-<?= $language['id'] ?>" data-toggle="tab"><?= $language['name'] ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <div class="tab-content">
                            <?php foreach ($languages as $language): ?>
                                <div id="tab-<?= $language['id'] ?>"
                                     class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>">
                                    <?= GridView::widget([
                                        'dataProvider' => $dataProviders[$language['code']],
                                        'columns' => [
                                            [
                                                'attribute' => 'category',
                                                'label' => Yii::t('language', 'Category', [], $language['code']),
                                            ],
                                            [
                                                'attribute' => 'message',
                                                'label' => Yii::t('language', 'Message', [], $language['code']),
                                                'contentOptions' => ['style' => 'max-width:200px; white-space: normal;'],
                                            ],
                                            [
                                                'header' => Yii::t('language', 'Translation', [], $language['code']),
                                                'value' => function ($model, $key, $index, $column) use ($language) {
                                                    return Html::textInput($language['code'] . '[' . $model->id . ']',
                                                        $model->alltranslations[0]->translation,
                                                        ['class' => 'form-control']);
                                                },
                                                'format' => 'raw',
                                            ],
                                        ],
                                        'tableOptions' => ['class' => 'table table-striped'],
                                        'summary' => '',
                                    ]);
                                    ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <?= Html::submitButton(Yii::t('language', 'Submit'), ['class' => 'btn btn-primary']) ?>
                        </div>
                    </div>
                    <?= Html::endForm() ?>
                </div>
            </div>
        </div>
    </div>
</div>
