<?php

namespace wdigital\cms\i18new\models;

use Yii;
use yii\db\ActiveRecord;

class Language extends ActiveRecord {

    const SCENARIO_CREATE = 1;
    protected static $_codeToIdMap;

    /**
     * @return array
     */
    public function rules(): array
    {
        return [
            [['code', 'name'], 'required'],
            ['code', 'string'],
            ['code', 'filter', 'filter' => 'strtolower'],
            ['code', 'unique'],
            ['active', 'safe'],
            ['code', 'string', 'max' => 6],
            ['order_by', 'filter', 'filter' => function () {
                return static::find()->max('order_by') + 1;
            }, 'on' => self::SCENARIO_CREATE],
        ];
    }

    /**
     * @return array
     */
    public function attributeLabels(): array
    {
        return [
            'code' => Yii::t('language', 'Language code'),
            'name' => Yii::t('language', 'Language name'),
            'active' => Yii::t('language', 'Is active'),
        ];
    }

    /**
     * @return mixed
     */
    protected static function getMapping()
    {
        if (empty(static::$_codeToIdMap)) {
            static::$_codeToIdMap = Language::find()
                ->select(['id', 'code'])
                ->indexBy('code')
                ->column();
        }
        return static::$_codeToIdMap;
    }
    /**
     * @param int $id
     * @return string
     */
    public static function getCodeFromId($id): string
    {
        $languages = array_flip(static::getMapping());
        if (empty($languages[$id])) {
            throw new InvalidParamException("The language ID #{$id} is not a configured application language");
        }
        return $languages[$id];
    }
    /**
     * @param string $code
     * @return int
     */
    public static function getIdFromCode($code): int
    {
        $languages = static::getMapping();
        if (empty($languages[$code])) {
            throw new InvalidParamException("The language code '{$code}' is not a configured application language");
        }
        return $languages[$code];
    }

}
