<?php

namespace wdigital\cms\i18new\migrations;

use yii\db\Migration;
/**
 * Handles the creation of table `language`.
 */
class m131114_140213_create_language_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%language}}', [
			'id' => $this->primaryKey()->unsigned(),
			'code' => $this->string(3)->notNull(),
			'name' => $this->string()->notNull(),
			'active' => $this->boolean()->notNull()->defaultValue(0),
			'order_by' => $this->integer()->notNull(),
		], $tableOptions);

        $this->createIndex(
            'idx_language_active', '{{%language}}', 'active'
        );
        $this->createIndex(
            'idx_language_code', '{{%language}}', 'code'
        );
        $this->createIndex(
            'idx_language_order_by', '{{%language}}', 'order_by'
        );
		$this->insert('{{%language}}', [
			'code' => 'lv',
			'name' => 'Latviešu',
			'active' => 1,
			'order_by' => 1,
		]);

    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('{{%language}}');
    }
}
