<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('language', 'Edit language: '). $model->name;
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <small class="pull-right"><?= Yii::t('language', 'By submitting this form, you can edit a language') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['edit', 'id' => $model->id],
                            ])
                    ?>
                    <?= $form->field($model, 'code')->dropDownList($languages, ['class' => 'js-select2 form-control']) ?>
                    <?= $form->field($model, 'name')->textInput() ?>
                    <?= $form->field($model, 'active')->checkbox(['class' => 'js-switch']) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('language', 'Edit'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
