<?php

namespace wdigital\cms\i18n;


use wdigital\cms\i18n\models\Language;
use Yii;
use yii\base\Application;
use yii\base\Exception;
use yii\base\Module as BaseModule;
use yii\console\Application as ConsoleApplication;
use yii\helpers\ArrayHelper;

class Module extends BaseModule
{
    public $languageClass = Language::class;
    
    public function init()
    {
        parent::init();
        try {
            if (Yii::$app instanceof yii\web\Application) {
                Yii::$app->params['languages'] = $this->languageClass::find()->asArray()->all();
                Yii::$app->urlManager->languages = ArrayHelper::getColumn(Yii::$app->params['languages'], 'code');
            }
        } catch (Exception $e) {
            throw new Exception("Please make sure you are using codemix\yii2-localeurls package as your urlManager!");
        }
    }
}
