<?php


namespace wdigital\cms\i18n\models;

use wdigital\cms\i18n\components\ActiveRecordHelper;
use wdigital\cms\i18n\models\Language;
use Yii;
use yii\db\ActiveRecord;

class StaticTranslationMessage extends ActiveRecord
{
	public static function tableName()
    {
        return '{{%message}}';
    }
    public function attributeLabels() {
        return [
            'translation' => Yii::t('language', 'Translation'),
        ];
    }

	public function updateMessages($data) {
        unset($data["_csrf"]);
        foreach ($data as $language => $translations) {
            $model = new Language();
            $language_codes = ActiveRecordHelper::getColumnValues($model, 'code');
            if (in_array($language, $language_codes)) {
                foreach ($translations as $id => $translation) {
                    if ($translation == '') {
                        $translation = null;
                    }
                    $query = Yii::$app->db
                            ->createCommand()
                            ->update(self::tableName(), ['translation' => $translation], ['id' => $id, 'language' => $language])
                            ->execute();
                }
            } else {
                continue;
            }
        }
    }

    public function deleteStaticTranslationsByLanguage(string $code)
    {
        Yii::$app->db->createCommand()->delete(self::tablename(), ['language' => $code])->execute();
    }
}
