<?php
namespace wdigital\cms\i18n\models;

use Yii;
use yii\db\ActiveRecord;
use wdigital\cms\i18n\models\StaticTranslationMessage;

class StaticTranslation extends ActiveRecord {

    public static function tableName()
    {
        return '{{%source_message}}';
    }

    public function attributeLabels() {
        return [
            'category' => Yii::t('language', 'Category'),
            'message' => Yii::t('language', 'Message'),
        ];
    }

    public function getAlltranslations(){
    	return $this->hasMany(StaticTranslationMessage::className(), ['id' => 'id']);
	}

    public function generateStaticTranslationMessages(string $code)
    {
        $translations = StaticTranslation::find()->all();
        $insertData = [];
        foreach($translations as $translation){
            $insertData[] = ['id' => $translation->id, 'language' => $code];
        }
        Yii::$app->db->createCommand()->batchInsert(StaticTranslationMessage::tablename(), ['id', 'language'], $insertData)->execute();
    }
}
