# White Digital CMS Internationalization Module

The CMS Internationalization management module. Create languages and respective static translations used by built-in Yii i18n.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-i18n:^1.0.0

or add

    "wdigital/cms-i18n": "^1.0.0"

to the `require` section of your `composer.json` file.


### 2. Configure

> IMPORTANT! Ensure that your application does not have a `language` component configured beforehand.
Add module and name it in application configuration (preferrably in common config)

    'modules' => [
        // ...
        'language' => [
            'class' => wdigital\cms\i18n\Module::class
        ]
    ],

Add newly added `language` module to your bootstrapping modules, to make sure that migrations are injected
and routing package can use languages from database.

    'bootstrap' => ['language'],
Add Yii2 i18n static translation component in your application configuration to use your applications database as source for translated messages.
Also add `language*` translation to get support for EN and LV languages for backend UI

    'components' => [
        'i18n' => [
            'translations' => [
                'language*' => [
                    'class' => PhpMessageSource::class,
                    'basePath' => '@vendor/wdigital/cms-i18n/src/messages',
                    'sourceLanguage' => 'en-US',
                ],
                '*' => [
                    'class' => 'yii\i18n\DbMessageSource',
                    'forceTranslation'=>true,
                ],
            ],
        ],
    ]

If dynamic translations are necessary, add dynamic translations by configuring component

        'translatableModelManager' => [
            'class' => wdigital\cms\i18n\components\translatableModel\Manager::class,
        ],

Source model has to use TranslatableTrait, and translation model has to use TranslatingTrait

### 3. Add migration namespace to console config and Migrate

    'controllerMap' => [
            'migrate' => [
                'class' => 'yii\console\controllers\MigrateController',
                'migrationNamespaces' => [
                    'wdigital\\cms\\i18n\\migrations',
                ]
            ],
    ],
    
    $ php yii migrate

### 4. When ready run console command to extract your applications static translations from code
You can do this as many times as you want, old translations will not be overwritten.

    $ php yii message vendor/wdigital/cms-i18n/src/messages.php

### 5. Configure application urlManager component, if you want to make your application multilingual
        'urlManager' => [
            'class' => codemix\localeurls\UrlManager::class,
            'languages' => [], //these will be overwritten by what you have in the database
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'enableDefaultLanguageUrlCode' => true,
            'enableLanguagePersistence' => false,
            'enableLanguageDetection' => false,
        ],

[composer]: http://getcomposer.org/download/

