<?php

use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;

/* @var $this View */
$this->title = Yii::t('language', 'Languages and translations');
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <!--Languages-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('language', 'Languages') ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('language', 'Add new language'),
                            Url::to(['create']),
                            ['class' => 'btn btn-primary btn-xs']) ?>
                    </div>
                </div>
                <div class="ibox-content">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            "code:text",
                            "name:text",
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header' => Yii::t('user', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'edit',
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'delete',
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('language', 'Delete language'),
                                            'data-text' => Yii::t('language', 'Are you sure, you want to delete language').' '.$model->name.'?',
                                            'data-cancel' => Yii::t('general', 'Cancel'),
                                            'data-ok' => Yii::t('general', 'Ok'),
                                        ]);
                                    },
                                ],
                            ]
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                        'summary' => ''
                    ]);
                    ?>
                </div>
            </div>
        </div>
    </div>
    <!--Translations-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('language', 'Translations') ?></h5>
                </div>
                <div class="ibox-content">
                    <?= Html::beginForm(['static', 'lang' => Yii::$app->language], 'post') ?>
                    <div class="tabs-container">
                        <ul class="nav nav-tabs">
                            <?php $first=true; foreach ($languages as $language): ?>
                            <li<?php if($first):?> class="active"<?php endif;?>>
                                <a href="#tab-<?=$language->id?>" data-toggle="tab"><?= $language->name ?></a>
                            </li>
                            <?php $first=false; endforeach; ?>
                        </ul>
                        <div class="tab-content">
                            <?php $first=true; foreach ($languages as $language): ?>
                                <div id="tab-<?= $language->id ?>" class="tab-pane fade<?=$first? 'in active':''?>">
                                    <?= GridView::widget([
                                        'dataProvider' => $dataProviders[$language->code],
                                        'columns' => [
                                            "category:text",
                                            "message:text",
                                            ['value' => function($model, $key, $index, $column) use ($language) {
                                                    return Html::textInput($language->code . '[' . $model->id . ']', $model->alltranslations[0]->translation,
                                                    ['class' => 'form-control']);
                                            }, 'format' => 'raw']
                                            ],
                                        'tableOptions' => ['class' => 'table table-striped'],
                                        'summary' => ''
                                    ]);
                                    ?>
                                </div>
                            <?php $first=false; endforeach; ?>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                                <?= Html::submitButton(Yii::t('general', 'Submit'), ['class' => 'btn btn-primary']) ?>
                        </div>
                    </div>
                    <?= Html::endForm() ?>
                </div>
            </div>
        </div>
    </div>
</div>
