<?php

namespace wdigital\cms\i18n\components\translatableModel;

use yii\di\ServiceLocator;

/**
 * @property Helper[] $models
 */
class Manager extends ServiceLocator
{
    /**
     * @var string
     */
    public $helperClass = Helper::class;

    /**
     * @inheritdoc
     */
    public function get($modelClass, $throwException = true)
    {
        if (!$this->has($modelClass)) {
            $this->set($modelClass);
        }
        return parent::get($modelClass, $throwException);
    }
    /**
     * @inheritdoc
     */
    public function set($modelClass, $definition = null)
    {
        if (empty($definition['class'])) {
            $definition['class'] = $this->helperClass;
        }
        if (empty($definition['modelClass'])) {
            $definition['modelClass'] = $modelClass;
        }
        parent::set($modelClass, $definition);
    }
    /**
     * @see parent::getComponents()
     * @param bool $returnDefinitions
     * @return array
     */
    public function getModels($returnDefinitions = true)
    {
        return parent::getComponents($returnDefinitions);
    }
    /**
     * @see parent::setComponents()
     * @param array $definitions
     */
    public function setModels($definitions)
    {
        parent::setComponents($definitions);
    }
}
