# White Digital CMS Internationalization Module

The CMS Internationalization management module. Create languages and respective static translations used by built-in Yii i18n.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-i18n:^1.0.0

or add

    "wdigital/cms-i18n": "^1.0.0"

to the `require` section of your `composer.json` file.


### 2. Configure

> IMPORTANT! Ensure that your application does not have a `language` component configured beforehand.
Add module and name it in application configuration

    'modules' => [
        // ...
        'language' => [
            'class' => wdigital\cms\i18n\Module::class
        ]
    ],

Add Yii2 i18n static translation component in your application configuration

    'components' => [
        'i18n' => [
            'translations' => [
                '*' => [
                    'class' => 'yii\i18n\DbMessageSource',
                    'forceTranslation'=>true,
                ],
            ],
        ],
    ]

### 3. Migrate

    $ php yii migrate/up --migrationNamespaces=wdigital\\cms\\i18n\\migrations

### 4. Run console command to extract static translations from code

    $ php yii message vendor/wdigital/cms-i18n/src/messages.php

[composer]: http://getcomposer.org/download/

