<?php

namespace wdigital\cms\i18n\models;

use Yii;
use yii\db\ActiveRecord;

class Language extends ActiveRecord {

    const SCENARIO_CREATE = 1;

    public function rules() {
        return [
            [['code', 'name'], 'required'],
            ['code', 'string'],
            ['code', 'filter', 'filter' => 'strtolower'],
            ['code', 'unique'],
            ['active', 'safe'],
            ['code', 'string', 'max' => 6],
            ['order_by', 'filter', 'filter' => function () {
                return static::find()->max('order_by') + 1;
            }, 'on' => self::SCENARIO_CREATE],
        ];
    }

    public function attributeLabels() {
        return [
            'code' => Yii::t('language', 'Language code'),
            'name' => Yii::t('language', 'Language name'),
        ];
    }

}
