<?php

use wdigital\cms\gallery\assets\GalleryAsset;
use wdigital\cms\inspinia\widgets\FileInput;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model wdigital\cms\gallery\models\multi\Gallery */
/* @var $form yii\widgets\ActiveForm */
GalleryAsset::register($this);

?>

<div class="gallery-form">

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> ><a
                        href="#new-<?=  $language['code'] ?>"
                        data-toggle="tab"><?=  Html::encode($language['name']); ?></a></li>
        <?php endforeach; ?>
    </ul>
    <div class="tab-content">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                 id="new-<?= $language['code'] ?>">

                <?php $translatedModel = $model->getVariationModel($language['id']); ?>

                <?= $form->field($translatedModel, "[{$language['id']}]title")->textInput(['maxlength' => true, 'data-slug-field' => "new-gallery-type-{$language['code']}", 'class' => 'form-control js-slug-field'])->label(Yii::t('app', 'Title', [], $language['code'])); ?>

                <?= $form->field($translatedModel, "[{$language['id']}]description")->widget(\wdigital\cms\siteTree\widgets\CKEditor::class)->label(Yii::t('app', 'Description', [], $language['code'])); ?>

            </div>
        <?php endforeach; ?>

        <?= $form->field($model, 'date')->textInput(['class' => 'form-control datepicker', 'value' => $model->date ? Yii::$app->formatter->asDate($model->date, 'php:d.m.Y') : '']) ?>

        <?= $form->field($model, 'author')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'published')->checkbox(['class' => 'js-icheck']) ?>

        <?= $form->field($model, 'galleryTypes')->dropDownList($types,
            ['class' => 'form-control js-select2', 'multiple' => 'multiple']) ?>

        <?= FileInput::widget([
            'model' => $photoUpload,
            'multiple' => 'multiple',
            'name' => 'PhotoUpload[images][]',
            'errorField' => 'images',
        ]); ?>

        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => 'btn btn-primary']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>