<?php

namespace wdigital\cms\gallery\migrations;
use wdigital\cms\gallery\models\multi\GalleryTranslation;
use yii\db\Migration;

/**
 * Class m190310_141220_add_slug_column_to_gallery_translations
 */
class m190310_141220_add_slug_column_to_gallery_translations extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $dbHasLanguage = $this->db->schema->getTableSchema('language', true);
        if (!$dbHasLanguage) {
            $this->addColumn('gallery', 'slug', $this->string()->notNull());
            $this->createIndex('idx_gallery_slug', 'gallery_translation', 'slug');
        } else {
            $this->addColumn('gallery_translation', 'slug', $this->string()->notNull());
            $this->createIndex('idx_gallery_translation_slug', 'gallery_translation', 'slug');
        }

        foreach (GalleryTranslation::find()->each() as $galleryTranslation) {
            $galleryTranslation->save();
        }

    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $dbHasLanguage = $this->db->schema->getTableSchema('language', true);
        if (!$dbHasLanguage) {
            $this->dropColumn('gallery', 'slug');

        } else {
            $this->dropColumn('gallery_translation', 'slug');
        }
    }
}
