<?php

namespace wdigital\cms\gallery\migrations;
use yii\db\Migration;

/**
 * Handles the creation of table `gallery`, `gallery_type`, `gallery_to_gallery_type`.
 */
class m171214_094639_create_gallery_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $dbHasLanguage = $this->db->schema->getTableSchema('language', true);
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        if (!$dbHasLanguage) {
            $this->createTable('{{%gallery}}', [
                'id' => $this->primaryKey()->unsigned(),
                'title' => $this->string(),
                'description' => $this->text(),
                'date' => $this->date(),
                'created_at' => $this->dateTime()->notNull(),
                'updated_at' => $this->dateTime()->notNull(),
                'author' => $this->string(),
                'published' => $this->boolean()->defaultValue(false)
            ], $tableOptions);

            $this->createIndex('idx_gallery_title', '{{%gallery}}', 'title');
            $this->createIndex('idx_gallery_date', '{{%gallery}}', 'date');
            $this->createIndex('idx_gallery_created_at', '{{%gallery}}', 'created_at');
            $this->createIndex('idx_gallery_updated_at', '{{%gallery}}', 'updated_at');
            $this->createIndex('idx_gallery_published', '{{%gallery}}', 'published');

            $this->createTable('{{%gallery_type}}', [
                'id' => $this->primaryKey()->unsigned(),
                'title' => $this->string(),
                'created_at' => $this->dateTime()->notNull(),
                'updated_at' => $this->dateTime()->notNull(),
            ], $tableOptions);

            $this->createIndex('idx_gallery_type_created_at', '{{%gallery_type}}', 'created_at');
            $this->createIndex('idx_gallery_type_updated_at', '{{%gallery_type}}', 'updated_at');

            $this->createTable('{{%gallery_to_gallery_type}}', [
                'gallery_id' => $this->integer()->notNull()->unsigned(),
                'gallery_type_id' => $this->integer()->notNull()->unsigned(),
            ], $tableOptions);

            $this->addPrimaryKey('pk_gallery_to_gallery_type', '{{%gallery_to_gallery_type}}', ['gallery_id', 'gallery_type_id']);
            $this->createIndex(
                'idx_gallery_to_gallery_id',
                '{{%gallery_to_gallery_type}}',
                'gallery_id'
            );
            $this->addForeignKey('fk_gallery_to_gallery_id', '{{%gallery_to_gallery_type}}', 'gallery_id', '{{%gallery}}', 'id', 'CASCADE', 'RESTRICT');
            $this->createIndex(
                'idx_gallery_to_gallery_type_id',
                '{{%gallery_to_gallery_type}}',
                'gallery_type_id'
            );
            $this->addForeignKey('fk_gallery_to_gallery_type_id', '{{%gallery_to_gallery_type}}', 'gallery_type_id', '{{%gallery_type}}', 'id', 'CASCADE', 'RESTRICT');

        } else {
            $this->createTable('{{%gallery}}', [
                'id' => $this->primaryKey()->unsigned(),
                'date' => $this->date(),
                'created_at' => $this->dateTime()->notNull(),
                'updated_at' => $this->dateTime()->notNull(),
                'author' => $this->string(),
                'published' => $this->boolean()->defaultValue(false)
            ], $tableOptions);

            $this->createIndex('idx_gallery_date', '{{%gallery}}', 'date');
            $this->createIndex('idx_gallery_created_at', '{{%gallery}}', 'created_at');
            $this->createIndex('idx_gallery_updated_at', '{{%gallery}}', 'updated_at');
            $this->createIndex('idx_gallery_published', '{{%gallery}}', 'published');

            $this->createTable('{{%gallery_type}}', [
                'id' => $this->primaryKey()->unsigned(),
                'created_at' => $this->dateTime()->notNull(),
                'updated_at' => $this->dateTime()->notNull(),
            ], $tableOptions);

            $this->createIndex('idx_gallery_type_created_at', '{{%gallery_type}}', 'created_at');
            $this->createIndex('idx_gallery_type_updated_at', '{{%gallery_type}}', 'updated_at');

            $this->createTable('{{%gallery_to_gallery_type}}', [
                'gallery_id' => $this->integer()->notNull()->unsigned(),
                'gallery_type_id' => $this->integer()->notNull()->unsigned(),
            ], $tableOptions);

            $this->addPrimaryKey('pk_gallery_to_gallery_type', '{{%gallery_to_gallery_type}}', ['gallery_id', 'gallery_type_id']);
            $this->createIndex(
                'idx_gallery_to_gallery_id',
                '{{%gallery_to_gallery_type}}',
                'gallery_id'
            );
            $this->addForeignKey('fk_gallery_to_gallery_id', '{{%gallery_to_gallery_type}}', 'gallery_id', '{{%gallery}}', 'id', 'CASCADE', 'RESTRICT');
            $this->createIndex(
                'idx_gallery_to_gallery_type_id',
                '{{%gallery_to_gallery_type}}',
                'gallery_type_id'
            );
            $this->addForeignKey('fk_gallery_to_gallery_type_id', '{{%gallery_to_gallery_type}}', 'gallery_type_id', '{{%gallery_type}}', 'id', 'CASCADE', 'RESTRICT');



            $this->createTable('{{%gallery_translation}}', [
                'gallery_id' => $this->integer()->unsigned()->notNull(),
                'language_id' => $this->integer()->unsigned()->notNull(),
                'title' => $this->string(),
                'description' => $this->text(),
            ], $tableOptions);

            $this->addPrimaryKey('pk_gallery_translation', '{{%gallery_translation}}', ['gallery_id', 'language_id']);
            $this->createIndex('idx_gallery_translation_title', '{{%gallery_translation}}', 'title');
            $this->createIndex('idx_gallery_translation_to_gallery', '{{%gallery_translation}}', 'gallery_id');
            $this->addForeignKey('fk_gallery_translation_to_gallery', '{{%gallery_translation}}', 'gallery_id', '{{%gallery}}', 'id', 'CASCADE', 'RESTRICT');
            $this->createIndex('idx_gallery_translation_to_language', '{{%gallery_translation}}', 'language_id');
            $this->addForeignKey('fk_gallery_translation_to_language', '{{%gallery_translation}}', 'language_id', '{{%language}}', 'id', 'CASCADE', 'RESTRICT');

            $this->createTable('{{%gallery_type_translation}}', [
                'gallery_type_id' => $this->integer()->unsigned()->notNull(),
                'language_id' => $this->integer()->unsigned()->notNull(),
                'title' => $this->string(),
            ], $tableOptions);

            $this->addPrimaryKey('pk_gallery_type_translation', '{{%gallery_type_translation}}', ['gallery_type_id', 'language_id']);
            $this->createIndex('idx_gallery_type_translation_to_gallery_type', '{{%gallery_type_translation}}', 'gallery_type_id');
            $this->addForeignKey('fk_gallery_type_translation_to_gallery_type', '{{%gallery_type_translation}}', 'gallery_type_id', '{{%gallery_type}}', 'id', 'CASCADE', 'RESTRICT');
            $this->createIndex('idx_gallery_type_translation_to_language', '{{%gallery_type_translation}}', 'language_id');
            $this->addForeignKey('fk_gallery_type_translation_to_language', '{{%gallery_type_translation}}', 'language_id', '{{%language}}', 'id', 'CASCADE', 'RESTRICT');
        }
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $dbHasLanguage = $this->db->schema->getTableSchema('language', true);
        if ($dbHasLanguage) {
            $this->dropForeignKey('fk_gallery_translation_to_language', '{{%gallery_translation}}');
            $this->dropForeignKey('fk_gallery_translation_to_gallery', '{{%gallery_translation}}');
            $this->dropTable('{{%gallery_translation}}');

            $this->dropForeignKey('fk_gallery_type_translation_to_language', '{{%gallery_type_translation}}');
            $this->dropForeignKey('fk_gallery_type_translation_to_gallery_type', '{{%gallery_type_translation}}');
            $this->dropTable('{{%gallery_type_translation}}');
        }

        $this->dropForeignKey('fk_gallery_to_gallery_id', '{{%gallery_to_gallery_type}}');
        $this->dropForeignKey('fk_gallery_to_gallery_type_id', '{{%gallery_to_gallery_type}}');
        $this->dropTable('{{%gallery_to_gallery_type}}');
        $this->dropTable('{{%gallery_type}}');
        $this->dropTable('{{%gallery}}');
    }
}
