<?php

use yii\helpers\StringHelper;
use yii\helpers\Url;

?>
<div class="photo-form">
    <table class="table table-striped js-sort"
           data-url=<?= Url::to(['photo/update-photo-order']); ?>
           data-toastr-success="<?= Yii::t('gallery', 'Photo changes successful'); ?>"
           data-toastr-error="<?= Yii::t('gallery', 'Photo changes unsuccessful'); ?>"
    >
        <?php foreach ($photos as $photo): ?>
            <tr data-id="<?= $photo->id ?>">
                <td><img style="max-height: 100px; max-width: 100px;" src="<?= $photo->getImageUrl(['w' => 200]) ?>"></td>
                <td>
                    <?php if (Yii::$app->getModule('gallery')->translate): ?>
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <?php $translatedModel = $photo->getVariationModel($language['id']); ?>
                            <input type="text"
                                   name="<?= StringHelper::basename(get_class($translatedModel))."[{$language['id']}][description]"; ?>"
                                   placeholder="<?= Yii::t('gallery', 'Picture description', [], $language['code']) . " {$language['code']}" ?>"
                                   class="form-control"
                                   value="<?= $translatedModel->getAttribute('description') ?>">
                        <?php endforeach; ?>
                    <?php else: ?>
                        <input type="text" name="<?= StringHelper::basename(get_class($photo)); ?>[description]"
                               placeholder="<?= Yii::t('gallery', 'Picture description') ?>" class="form-control"
                               value="<?= $photo->description ?>">
                    <?php endif; ?>
                </td>
                <td align="right" class="w120px">
                    <button data-id="<?= $photo->id ?>" data-direction="90"
                            data-url="<?= Url::to(['photo/rotate-photo', 'id' => $photo->id]); ?>"
                            class="btn btn-xs btn-primary js-rotate-photo"><i class="fa fa-fw fa-undo"></i></button>
                    <button data-id="<?= $photo->id ?>" data-direction="-90"
                            data-url="<?= Url::to(['photo/rotate-photo', 'id' => $photo->id]); ?>"
                            class="btn btn-xs btn-primary js-rotate-photo"><i class="fa fa-fw fa-repeat"></i></button>
                    <button
                            class="btn btn-xs btn-primary js-photo-description"
                            data-url="<?= Url::to(['photo/update-photo-description', 'id' => $photo->id]); ?>"
                            data-toastr-success="<?= Yii::t('gallery', 'Photo changes successful'); ?>"
                            data-toastr-error="<?= Yii::t('gallery', 'Photo changes unsuccessful'); ?>"
                    >
                        <i class="fa fa-fw fa-save"></i>
                    </button>
                    <button href="#"
                            class="btn btn-warning btn-xs sortable-handle">
                        <i class="fa fa-arrows fa-fw"></i>
                    </button>
                    <a href="<?= Url::to(['photo/delete', 'resourceId' => $photo->id, 'id' => $id]) ?>"
                       class="btn btn-xs btn-danger sweetalert-warning"
                       data-title="<?= Yii::t('gallery', 'Delete picture') ?>"
                       data-text="<?= Yii::t('gallery', 'Are you sure, you want to delete this picture?') ?>"
                    >
                        <i class="fa fa-trash fa-fw"></i>
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
