<?php

namespace wdigital\cms\gallery\models\multi;

use DateTime;
use Exception;
use wdigital\cms\i18new\components\ActiveRecordHelper;
use wdigital\cms\i18new\models\Language;
use Yii;
use yii\base\InvalidConfigException;
use yii\base\Model;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
use yii2tech\ar\variation\VariationBehavior;

/**
 * This is the model class for table "gallery_type".
 *
 * @property int $id
 * @property string $created_at
 * @property string $updated_at
 *
 * @property Gallery[] $galleries
 * @property GalleryTypeTranslation[] $galleryTypeTranslations
 * @property Language[] $languages
 * @method hasDefaultVariationRelation()
 * @method getVariationModels()
 * @method setVariationModels(array $translationModels)
 */
class GalleryType extends ActiveRecord
{

    /**
     * @return string
     */
    public static function primaryField(): string
    {
        return 'created_at';
    }

    /**
     * @return array
     * @throws Exception
     */
    public function behaviors(): array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => 'galleryTypeTranslations',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'optionModelClass' => Language::class,
                'defaultVariationOptionReference' => Language::getIdFromCode(Yii::$app->language),
                'variationSaveFilter' => [ActiveRecordHelper::class, 'filterVariationSave'],
            ],
            [
                'class' => TimestampBehavior::class,
                'value' => (new DateTime())->format('Y-m-d H:i:s'),
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return 'gallery_type';
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'id' => 'ID',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @throws InvalidConfigException
     * @return ActiveQuery
     */
    public function getGalleries(): ActiveQuery
    {
        return $this->hasMany(Gallery::class, ['id' => 'gallery_id'])->viaTable('gallery_to_gallery_type', ['gallery_type_id' => 'id']);
    }

    /**
     * @return ActiveQuery
     */
    public function getGalleryTypeTranslations(): ActiveQuery
    {
        return $this->hasMany(GalleryTypeTranslation::class, ['gallery_type_id' => 'id']);
    }

    /**
     * @return ActiveQuery
     */
    public function getDefaultTranslation(): ActiveQuery
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
     * @param array $data
     * @param null $formName
     * @return bool
     */
    public function load($data, $formName = null): bool
    {
        $translationModels = ArrayHelper::map(
            $this->getVariationModels(),
            'language_id',
            function ($translatedModel) {
                return $translatedModel;
            }
        );
        return Model::loadMultiple($translationModels, $data) && $this->setVariationModels($translationModels);
    }

}