<?php

namespace wdigital\cms\gallery\controllers;

use wdigital\cms\gallery\assets\GalleryAsset;
use wdigital\cms\gallery\models\single\PhotoUpload;
use Yii;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;

/**
 * DefaultController implements the CRUD actions for Gallery model.
 */
class DefaultController extends Controller
{

    /**
     * Lists all Gallery models.
     * @param int $id
     * @return mixed
     */
    public function actionIndex(int $id)
    {
        GalleryAsset::register($this->view);
        $searchModel = Yii::$app->getModule('gallery')->gallerySearchClass;
        $searchModel = new $searchModel();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $galleryTypeClass = new $galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $query = $galleryTypeClass::find()->innerJoinWith(['defaultTranslation'])->where(['not', [$galleryTypeClass::primaryField() => null]]);
        } else {
            $query = $galleryTypeClass::find();
        }
        $typeProvider = new ActiveDataProvider([
           'query' => $query,
        ]);
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'typeProvider' => $typeProvider,
            'id' => $id,
        ]);
    }

    /**
     * Creates a new Gallery model.
     * If creation is successful, the browser will be redirected to the 'index' page.
     * @return mixed
     */
    public function actionCreate(int $id)
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        $model = new $galleryClass;
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save()
                && (empty(UploadedFile::getInstances($photoUpload, 'images'))
                || $model->saveRelatedPhotos($photoUpload))) {
            return $this->redirect(['update', 'id' => $id, 'resourceId' => $model->id]);
        }
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $classInstance = new $galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $types = $classInstance::find()->innerJoinWith(['defaultTranslation'])->where(['not', [$galleryTypeClass::primaryField() => null]])->select('title')->indexBy('id')->column();

        } else {
            $types = $classInstance::find()->select('title')->indexBy('id')->column();

        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/create', [
                    'model' => $model,
                    'types' => $types,
                    'photoUpload' => $photoUpload,
                    'id' => $id,
        ]);
    }

    /**
     * Updates an existing Gallery model.
     * If update is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @param int $resourceId
     * @return mixed
     * @throws NotFoundHttpException
     */
    public function actionUpdate(int $id, int $resourceId)
    {
        $model = $this->findModel($resourceId);
        $photoUpload = new PhotoUpload();
        if ($model->load(Yii::$app->request->post()) && $model->save() && (empty(UploadedFile::getInstances($photoUpload, 'images')) || $model->saveRelatedPhotos($photoUpload))) {
            return $this->redirect(['update', 'id' => $id, 'resourceId' => $resourceId]);
        }
        $photoClass = Yii::$app->getModule('gallery')->photoClass;
        $photoClass = new $photoClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $query = $photoClass::find()->with(['defaultTranslation']);
        } else {
            $query = $photoClass::find();
        }
        $photos = $query->andwhere(['gallery_id' => $model->id])->orderBy('order_by')->all();
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $types = $galleryTypeClass::find()->innerJoinWith(['defaultTranslation'])->where(['not', [$galleryTypeClass::primaryField() => null]])->select('title')->indexBy('id')->column();
        } else {
            $types = $galleryTypeClass::find()->select('title')->indexBy('id')->column();

        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/default/update', [
                    'model' => $model,
                    'types' => $types,
                    'photos' => $photos,
                    'photoUpload' => $photoUpload,
                    'id' => $id,
        ]);
    }

    /**
     * Deletes an existing Gallery model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $resourceId
     * @param integer $id
     * @return mixed
     */
    public function actionDelete(int $id, int $resourceId)
    {
        $model = $this->findModel($resourceId);
        if(!empty($model->photos)){
            foreach($model->photos as $photo) {
                $photo->destroy();
            }
        }
        $model->delete();
        return $this->redirect(['index', 'id' => $id]);
    }

    /**
     * Finds the Gallery model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Gallery the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        if (($model = $galleryClass::find()->where([$galleryClass::tableName().'.id' => $id])->limit(1)->one()) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException();
        }
    }
}
