<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model wdigital\cms\gallery\models\multi\GalleryType */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="gallery-type-form">

    <?php $form = ActiveForm::begin(['enableClientValidation' => false]); ?>

    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> ><a
                        href="#new-<?= $language['code'] ?>"
                        data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
        <?php endforeach; ?>
    </ul>
    <div class="tab-content">
        <?php foreach (Yii::$app->params['languages'] as $language): ?>
            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                 id="new-<?= $language['code'] ?>">

                <?php $translatedModel = $model->getVariationModel($language['id']); ?>

                <?= $form->field($translatedModel, "[{$language['id']}]title")->textInput(['maxlength' => true, 'class' => 'form-control'])->label($model->getAttributeLabel('title')); ?>

            </div>
        <?php endforeach; ?>

        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => 'btn btn-primary']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>