<?php

namespace wdigital\cms\gallery\controllers;

use Throwable;
use wdigital\cms\gallery\models\multi\GalleryType;
use Yii;
use yii\db\StaleObjectException;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

/**
 * GalleryTypeController implements the CRUD actions for GalleryType model.
 */
class GalleryTypeController extends Controller
{

    /**
     * Creates a new GalleryType model.
     * If creation is successful, the browser will be redirected to the 'default/index' page.
     * @return mixed
     */
    public function actionCreate(int $id)
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = new $galleryTypeClass;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index', 'id' => $id]);
        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/gallery-type/create', [
            'model' => $model,
            'id' => $id
        ]);
    }

    /**
     * Updates an existing GalleryType model.
     * If update is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id, $resourceId)
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = $galleryTypeClass::find()
            ->where([$galleryTypeClass::tableName().'.id' => $resourceId])
            ->limit(1)->one();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index', 'id' => $id]);
        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/gallery-type/update', [
            'model' => $model,
            'id' => $id
        ]);
    }

    /**
     * Deletes an existing GalleryType model.
     * If deletion is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException
     * @throws Throwable
     * @throws StaleObjectException
     */
    public function actionDelete($id, $resourceId)
    {
        $this->findModel($resourceId)->delete();

        return $this->redirect(['default/index', 'id' => $id]);
    }

    /**
     * Finds the GalleryType model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return GalleryType
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id): GalleryType
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        if (($model = $galleryTypeClass::find()->where(['id' => $id])->limit(1)->one()) !== null) {
            return $model;
        }
        throw new NotFoundHttpException();
    }
}
