<?php

namespace wdigital\cms\gallery\models\multi;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * GallerySearch represents the model behind the search form about `wdigital\cms\gallery\models\Gallery`.
 */
class GallerySearch extends Gallery
{
    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['id', 'published'], 'integer'],
            [['date', 'author'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios(): array
    {
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params): ActiveDataProvider
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        $query = new $galleryClass;
        if(Yii::$app->getModule('gallery')->translate) {
            $query = $query::find()->innerJoinWith('defaultTranslation')->where(['NOT', [$query::primaryField() => null]]);
        } else {
            $query = $query::find();
        }



        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'date' => $this->date,
            'published' => $this->published,
        ]);

        $query->andFilterWhere(['like', 'author', $this->author]);

        return $dataProvider;
    }
}
