<?php


namespace wdigital\cms\gallery\models\multi;

use wdigital\cms\i18new\models\Language;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "gallery_translation".
 *
 * @property int $gallery_id
 * @property int $language_id
 * @property string $title
 * @property string $description
 */
class GalleryTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return 'gallery_translation';
    }

    /**
     * @return array
     */
    public static function fillable() :array
    {
        return [
            'title',
            'description',
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['gallery_id', 'language_id'], 'integer'],
            [['description'], 'string'],
            [['title'], 'string', 'max' => 255],
            [['gallery_id', 'language_id'], 'unique', 'targetAttribute' => ['gallery_id', 'language_id']],
            [['gallery_id'], 'exist', 'skipOnError' => true, 'targetClass' => Gallery::class, 'targetAttribute' => ['gallery_id' => 'id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => Language::class, 'targetAttribute' => ['language_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'gallery_id' => 'Gallery ID',
            'language_id' => 'Language ID',
            'title' => 'Title',
            'description' => 'Description',
        ];
    }
}