<?php

namespace wdigital\cms\gallery;

use yii\base\Module as BaseModule;

class Module extends BaseModule
{
    public $translate;
    public $galleryClass;
    public $galleryTypeClass;
    public $photoClass;
    public $gallerySearchClass;

    public function __construct($id, $parent = null, array $config = [])
    {
        if (empty($config['translate'])) {
            $config['translate'] = false;
        }
        if (!$config['translate']) {
            if (empty($config['galleryClass'])) {
                $config['galleryClass'] = models\single\Gallery::class;
            }
            if (empty($config['galleryTypeClass'])) {
                $config['galleryTypeClass'] = models\single\GalleryType::class;
            }
            if (empty($config['photoClass'])) {
                $config['photoClass'] = models\single\Photo::class;
            }
            if (empty($config['gallerySearchClass'])) {
                $config['gallerySearchClass'] = models\single\GallerySearch::class;
            }
        } else {
            if (empty($config['galleryClass'])) {
                $config['galleryClass'] = models\multi\Gallery::class;
            }
            if (empty($config['galleryTypeClass'])) {
                $config['galleryTypeClass'] = models\multi\GalleryType::class;
            }
            if (empty($config['photoClass'])) {
                $config['photoClass'] = models\multi\Photo::class;
            }
            if (empty($config['gallerySearchClass'])) {
                $config['gallerySearchClass'] = models\multi\GallerySearch::class;
            }
        }
        parent::__construct($id, $parent, $config);
    }
}
