<?php

namespace wdigital\cms\gallery\models\single;

use wdigital\cms\gallery\components\FileControl;
use Yii;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\web\UploadedFile;

/**
 * This is the model class for table "{{%photo}}".
 *
 * @property integer $id
 * @property integer $gallery_id
 * @property string $filename
 * @property string $description
 * @property integer $order_by
 *
 * @property Gallery $gallery
 */
class Photo extends ActiveRecord
{

    const IMG_DIR = 'gallery/photos';
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%photo}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['gallery_id'], 'required'],
            [['gallery_id', 'order_by'], 'integer'],
            [['filename', 'description'], 'string', 'max' => 255],
            [['gallery_id'], 'exist', 'skipOnError' => true, 'targetClass' => Gallery::className(), 'targetAttribute' => ['gallery_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gallery', 'ID'),
            'gallery_id' => Yii::t('gallery', 'Gallery ID'),
            'filename' => Yii::t('gallery', 'Filename'),
            'description' => Yii::t('gallery', 'Description'),
            'order_by' => Yii::t('gallery', 'Order By'),
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getGallery()
    {
        return $this->hasOne(Gallery::className(), ['id' => 'gallery_id']);
    }

    /**
     * Creates a new Photo model and generates its filename.
     * @param UploadedFile $data UploadedFile instance that contains file.
     * @param Gallery $model Gallery instance that newly create model will be related to.
     * @return bool
     */
    public function create(UploadedFile $data, Gallery $model) :bool
    {
        $this->gallery_id = $model->id;
        $this->filename = FileControl::generateFileName($data);
        $last_photo = self::find()->where(['gallery_id'=> $model->id])->orderBy('order_by desc')->limit(1)->one();
        if($last_photo == null){
            $this->order_by = 0;
        }else{
            $this->order_by = $last_photo->order_by +1;
        }
        return $this->save();
    }

    /**
     * Returns models file location as URL.
     * @return string
     */
    public function getImageUrl()
    {
        return "/".self::IMG_DIR."/{$this->filename}";
    }

    /**
     * Deletes Deletes an existing Photo model and its related file on filesystem.
     * @return bool
     */
    public function destroy() :bool
    {
        if (FileControl::deleteFile(Gallery::IMG_DIR, $this->filename)) {
            if($this->delete() === false){
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
}
