<?php

namespace wdigital\cms\gallery\components;

use Yii;
use yii\helpers\FileHelper;
use yii\web\UploadedFile;

class FileControl {

    public static function generateFileName(UploadedFile $file) :string
    {
        return Yii::$app->security->generateRandomString() . '.' . $file->extension;
    }

    public static function uploadFile(UploadedFile $file, string $to, string $filename) :bool
    {
        $directory = Yii::getAlias('@webroot').'/'. $to;
        if (!file_exists($directory)) {
            FileHelper::createDirectory($directory, 0775, true);
        }
        return $file->saveAs($directory . '/' . $filename);
    }

    public static function deleteFile(string $folder, string $file) :bool
    {
        $storage = Yii::getAlias('@webroot');
        $full_path = "{$storage}/{$folder}/{$file}";
        if (empty($full_path) || !file_exists($full_path)) {
            return false;
        } if (!unlink($full_path)) {
            return false;
        } else {
            return true;
        }
    }

}
