<?php

use yii\grid\ActionColumn;
use yii\grid\SerialColumn;
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $searchModel wdigital\cms\gallery\models\single\GallerySearch|wdigital\cms\gallery\models\multi\GallerySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('gallery', 'Galleries');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="gallery-type-index">
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode(Yii::t('gallery', 'Gallery Types')) ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('gallery', 'Add new gallery-type'), ['gallery-type/create'],
                            ['class' => 'btn btn-primary btn-xs']) ?>
                    </div>
                </div>
                <div class="ibox-content">
                    <?= GridView::widget([
                        'dataProvider' => $typeProvider,
                        'columns' => [
                            ['class' => SerialColumn::class],
                            'title',
                            'updated_at:datetime',
                            [
                                'class' => ActionColumn::class,
                                'header' => Yii::t('gallery', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'gallery-type/update',
                                                'id' => $model->id,
                                            ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'gallery-type/delete',
                                                'id' => $model->id,
                                            ]), [
                                            'class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('gallery', 'Delete gallery-type'),
                                            'data-text' => Yii::t('gallery',
                                                    'Are you sure, you want to delete gallery-type') . ' ' . $model->title . '?',
                                            'data-cancel' => Yii::t('gallery', 'Cancel'),
                                            'data-ok' => Yii::t('gallery', 'Ok'),
                                        ]);
                                    },
                                ],
                            ],
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="gallery-index">
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('gallery', 'Add new gallery'), ['create'],
                            ['class' => 'btn btn-primary btn-xs']) ?>                    </div>
                </div>
                <div class="ibox-content">
                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => SerialColumn::class],
                            'title',
                            'date:date',
                            'updated_at:datetime',
                            'author',
                            [
                                'class' => ActionColumn::class,
                                'header' => Yii::t('gallery', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'update',
                                                'id' => $model->id,
                                            ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'delete',
                                                'id' => $model->id,
                                            ]), [
                                            'class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('gallery', 'Delete gallery'),
                                            'data-text' => Yii::t('gallery',
                                                    'Are you sure, you want to delete gallery') . ' ' . $model->title . '?',
                                            'data-cancel' => Yii::t('gallery', 'Cancel'),
                                            'data-ok' => Yii::t('gallery', 'Ok'),
                                        ]);
                                    },
                                ],
                            ],
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
</div>
