<?php

namespace wdigital\cms\gallery\models\multi;


use wdigital\cms\i18new\models\Language;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "photo_translation".
 *
 * @property int $photo_id
 * @property int $language_id
 * @property string $description
 */
class PhotoTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return 'photo_translation';
    }

    /**
     * @return array
     */
    public static function fillable(): array
    {
        return [
            'description',
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['photo_id', 'language_id'], 'integer'],
            [['description'], 'string', 'max' => 255],
            [['photo_id', 'language_id'], 'unique', 'targetAttribute' => ['photo_id', 'language_id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => Language::class, 'targetAttribute' => ['language_id' => 'id']],
            [['photo_id'], 'exist', 'skipOnError' => true, 'targetClass' => Photo::class, 'targetAttribute' => ['photo_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'photo_id' => 'Photo ID',
            'language_id' => 'Language ID',
            'description' => 'Description',
        ];
    }
}