<?php


namespace wdigital\cms\gallery\models\multi;


use wdigital\cms\i18new\models\Language;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "gallery_type_translation".
 *
 * @property int $gallery_type_id
 * @property int $language_id
 * @property string $title
 */
class GalleryTypeTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     * @return array
     */
    public static function tableName(): string
    {
        return 'gallery_type_translation';
    }

    /**
     * @return array
     */
    public static function fillable(): array
    {
        return [
            'title',
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['gallery_type_id', 'language_id'], 'integer'],
            [['title'], 'string', 'max' => 255],
            [['gallery_type_id', 'language_id'], 'unique', 'targetAttribute' => ['gallery_type_id', 'language_id']],
            [['gallery_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => GalleryType::class, 'targetAttribute' => ['gallery_type_id' => 'id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => Language::class, 'targetAttribute' => ['language_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'gallery_type_id' => 'Gallery Type ID',
            'language_id' => 'Language ID',
            'title' => 'Title',
        ];
    }
}