<?php

namespace wdigital\cms\gallery\controllers;

use Throwable;
use wdigital\cms\gallery\models\multi\GalleryType;
use Yii;
use yii\db\StaleObjectException;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

/**
 * GalleryTypeController implements the CRUD actions for GalleryType model.
 */
class GalleryTypeController extends Controller
{

    /**
     * Creates a new GalleryType model.
     * If creation is successful, the browser will be redirected to the 'default/index' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = new $galleryTypeClass;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index']);
        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/gallery-type/create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GalleryType model.
     * If update is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        $model = $galleryTypeClass::find()
            ->where([$galleryTypeClass::tableName().'.id' => $id])
            ->limit(1)->one();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['default/index']);
        }
        return $this->render('@vendor/wdigital/cms-gallery/src/views/gallery-type/update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GalleryType model.
     * If deletion is successful, the browser will be redirected to the 'default/index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException
     * @throws Throwable
     * @throws StaleObjectException
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['default/index']);
    }

    /**
     * Finds the GalleryType model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return GalleryType
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id): GalleryType
    {
        $galleryTypeClass = Yii::$app->getModule('gallery')->galleryTypeClass;
        if (($model = $galleryTypeClass::find()->where(['id' => $id])->limit(1)->one()) !== null) {
            return $model;
        }
        throw new NotFoundHttpException();
    }
}
