$(".js-photo-description").click(function () {
    var url = $(this).attr('data-url');
    var toastrSuccess = $(this).attr('data-toastr-success');
    var toastrError = $(this).attr('data-toastr-error');
    var inputs = $(this).parent().parent().find("input");
    var postObject = {};
    $.each(inputs, function (key, value) {
        postObject[$(this).attr('name')] = $(this).val();
    });
    $.post(url, postObject)
            .done(function (data, status, jqXHR) {
                if (jqXHR.responseJSON.data.hasOwnProperty('message')) {
                    toastr['success'](jqXHR.responseJSON.data.message, toastrSuccess);
                } else {
                    toastr['success']("", toastrSuccess);
                }
            })
            .fail(function (jqXHR) {
                console.log(jqXHR);
                if (jqXHR.responseJSON.hasOwnProperty('message')) {
                    toastr['error'](jqXHR.responseJSON.message, toastrError);
                } else {
                    toastr['error']("", toastrError);
                }
            });
});

$(".js-rotate-photo").click(function (e) {
    var url = $(this).attr('data-url');
    var toastrSuccess = $(this).attr('data-toastr-success');
    var toastrError = $(this).attr('data-toastr-error');
    var tr =  $(this).closest('tr');
    var postObject = {};
    postObject.direction = $(this).data('direction');
    $.post(url, postObject)
        .done(function (data, status, jqXHR) {
            if (jqXHR.responseJSON.data.hasOwnProperty('message')) {
                toastr['success'](jqXHR.responseJSON.data.message, toastrSuccess);
            } else {
                toastr['success']("", toastrSuccess);
            }
            var img = tr.find('img');
            var currentDeg = getRotationDegrees(img);
            img.rotate(currentDeg - postObject.direction);

        })
        .fail(function (jqXHR) {
            console.log(jqXHR);
            if (jqXHR.responseJSON.hasOwnProperty('message')) {
                toastr['error'](jqXHR.responseJSON.message, toastrError);
            } else {
                toastr['error']("", toastrError);
            }
        });
});


function getRotationDegrees(obj) {
    var matrix = obj.css("-webkit-transform") ||
        obj.css("-moz-transform")    ||
        obj.css("-ms-transform")     ||
        obj.css("-o-transform")      ||
        obj.css("transform");
    if(matrix !== 'none') {
        var values = matrix.split('(')[1].split(')')[0].split(',');
        var a = values[0];
        var b = values[1];
        var angle = Math.round(Math.atan2(b, a) * (180/Math.PI));
    } else { var angle = 0; }
    return (angle < 0) ? angle + 360 : angle;
}
