<?php

namespace wdigital\cms\gallery\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use yii\helpers\ArrayHelper;

/**
 * GallerySearch represents the model behind the search form about `wdigital\cms\gallery\models\Gallery`.
 */
class GallerySearch extends \yii\db\ActiveRecord
{
    public static function tableName()
    {
        return Yii::$app->getModule('gallery')->galleryClass::tableName();
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'published'], 'integer'],
            [['title', 'description', 'date', 'author'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $galleryClass = Yii::$app->getModule('gallery')->galleryClass;
        $query = new $galleryClass;
        if(Yii::$app->getModule('gallery')->translate
            && ArrayHelper::keyExists('wdigital\cms\i18n\components\translatableModel\TranslatableTrait', class_uses($query))) {
            $query = $query::find()->where([$query::tableName().'.language' => Yii::$app->language]);
        } else {
            $query = $query::find();
        }



        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'date' => $this->date,
            'published' => $this->published,
        ]);

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'author', $this->author]);

        return $dataProvider;
    }
}
