<?php

namespace wdigital\cms\gallery\models;

use Yii;

/**
 * This is the model class for table "{{%gallery_type}}".
 *
 * @property integer $id
 * @property string $title
 *
 * @property GalleryToGalleryType[] $galleryToGalleryTypes
 * @property Gallery[] $galleries
 */
class GalleryType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%gallery_type}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['title'], 'string', 'max' => 255],
            ['title', 'required'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gallery', 'ID'),
            'title' => Yii::t('gallery', 'Title'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGalleryToGalleryTypes()
    {
        return $this->hasMany(GalleryToGalleryType::className(), ['gallery_type_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGalleries()
    {
        return $this->hasMany(Gallery::className(), ['id' => 'gallery_id'])->viaTable('{{%gallery_to_gallery_type}}', ['gallery_type_id' => 'id']);
    }
}
