White Digital Yii2 Gallery Module Package
===========================================================

## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-gallery:^0.1.0

or add

    "wdigital/cms-gallery": "^0.1.0"

to the `require` section of your `composer.json` file.

### 2. Configure

Configure gallery module for your application

> IMPORTANT! Ensure that your application does not have a `gallery` component configured beforehand.
Add module and name it in application configuration

   Module config if translations are needed.
    
        'modules' => [
            gallery' => [
                'class' => wdigital\cms\gallery\Module::class,
                'translate' => true, //optional, set to false if you dont need translations to be enabled
                'galleryClass' => \common\models\Gallery::class, // optional, use custom class that extends translatable trait to use translations
                'galleryTypeClass' => \common\models\GalleryType::class, // optional, use custom class that extends translatable trait to use translations
                'photoClass' => \common\models\Photo::class, // optional, use custom class that extends translatable trait to use translations
            ],
        ],
        
   Module config if no translations are needed.
        
        'modules' => [
                    gallery' => [
                        'class' => wdigital\cms\gallery\Module::class,
                    ],
                ],

Configure response formatter component for your application to use standartizied Jsend responses to AJAX calls

        'response' => [
            'formatters' => [
                \yii\web\Response::FORMAT_JSON => [
                    'class' => wdigital\cms\gallery\components\JsendResponseFormatter::class,
                ],
            ],
        ],

Add a common storage location and name it '@storage' in common/bootstrap.php file for your application to save files on filesystem

        Yii::setAlias('@storage', dirname(dirname(__DIR__)) . '/storage');

### 3. Add migration namespace to console config and Migrate

    'controllerMap' => [
            'migrate' => [
                'class' => 'yii\console\controllers\MigrateController',
                'migrationNamespaces' => [
                    'wdigital\\cms\\gallery\\migrations',
                ]
            ],
    ],
    
    $ php yii migrate
    
### 4. Also add `gallery*` translation to get support for EN and LV languages for backend UI
       
           'components' => [
               'i18n' => [
                   'translations' => [
                       'gallery*' => [
                           'class' => PhpMessageSource::class,
                           'basePath' => '@vendor/wdigital/cms-gallery/src/messages',
                           'sourceLanguage' => 'en-US',
                       ],
                   ],
               ],
           ]
           
### 5. Add gallery asset to your application asset dependencies (depends in AppAsset) or assetManager configuration

        'wdigital\cms\gallery\assets\GalleryAsset',
        